/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrozenSet;
import org.python.core.PyFrozenSetDerived;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PySetDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSet
extends PyObject
implements Set {
    protected Set<PyObject> _set;

    protected BaseSet(PyType pyType, Set<PyObject> set) {
        super(pyType);
        this._set = set;
    }

    protected void _update(PyObject pyObject) {
        BaseSet._update(this._set, pyObject);
    }

    protected static Set<PyObject> _update(Set<PyObject> set, PyObject pyObject) {
        if (pyObject == null) {
            return set;
        }
        if (pyObject instanceof BaseSet) {
            set.addAll(((BaseSet)pyObject)._set);
            return set;
        }
        for (PyObject pyObject2 : pyObject.asIterable()) {
            set.add(pyObject2);
        }
        return set;
    }

    @Override
    public PyObject __or__(PyObject pyObject) {
        return this.baseset___or__(pyObject);
    }

    final PyObject baseset___or__(PyObject pyObject) {
        if (!(pyObject instanceof BaseSet)) {
            return null;
        }
        return this.baseset_union(pyObject);
    }

    @Override
    public PyObject __and__(PyObject pyObject) {
        return this.baseset___and__(pyObject);
    }

    final PyObject baseset___and__(PyObject pyObject) {
        if (!(pyObject instanceof BaseSet)) {
            return null;
        }
        return this.baseset_intersection(pyObject);
    }

    @Override
    public PyObject __sub__(PyObject pyObject) {
        return this.baseset___sub__(pyObject);
    }

    final PyObject baseset___sub__(PyObject pyObject) {
        if (!(pyObject instanceof BaseSet)) {
            return null;
        }
        return this.baseset_difference(pyObject);
    }

    public PyObject difference(PyObject pyObject) {
        return this.baseset_difference(pyObject);
    }

    final PyObject baseset_difference(PyObject pyObject) {
        BaseSet baseSet = pyObject instanceof BaseSet ? (BaseSet)pyObject : new PySet(pyObject);
        Set<PyObject> set = baseSet._set;
        BaseSet baseSet2 = BaseSet.makeNewSet(this.getType());
        for (PyObject pyObject2 : this._set) {
            if (set.contains(pyObject2)) continue;
            baseSet2._set.add(pyObject2);
        }
        return baseSet2;
    }

    @Override
    public PyObject __xor__(PyObject pyObject) {
        return this.baseset___xor__(pyObject);
    }

    final PyObject baseset___xor__(PyObject pyObject) {
        if (!(pyObject instanceof BaseSet)) {
            return null;
        }
        return this.baseset_symmetric_difference(pyObject);
    }

    public PyObject symmetric_difference(PyObject pyObject) {
        return this.baseset_symmetric_difference(pyObject);
    }

    final PyObject baseset_symmetric_difference(PyObject pyObject) {
        BaseSet baseSet = pyObject instanceof BaseSet ? (BaseSet)pyObject : new PySet(pyObject);
        BaseSet baseSet2 = BaseSet.makeNewSet(this.getType());
        for (PyObject pyObject2 : this._set) {
            if (baseSet._set.contains(pyObject2)) continue;
            baseSet2._set.add(pyObject2);
        }
        for (PyObject pyObject2 : baseSet._set) {
            if (this._set.contains(pyObject2)) continue;
            baseSet2._set.add(pyObject2);
        }
        return baseSet2;
    }

    @Override
    public abstract int hashCode();

    @Override
    public int __len__() {
        return this.baseset___len__();
    }

    final int baseset___len__() {
        return this._set.size();
    }

    @Override
    public boolean __nonzero__() {
        return !this._set.isEmpty();
    }

    @Override
    public PyObject __iter__() {
        return this.baseset___iter__();
    }

    final PyObject baseset___iter__() {
        return new PyIterator(){
            private int size;
            private Iterator<PyObject> iterator;
            {
                this.size = BaseSet.this.size();
                this.iterator = BaseSet.this._set.iterator();
            }

            public PyObject __iternext__() {
                if (this.size != BaseSet.this.size()) {
                    throw Py.RuntimeError("set changed size during iteration");
                }
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }
        };
    }

    @Override
    public boolean __contains__(PyObject pyObject) {
        return this.baseset___contains__(pyObject);
    }

    final boolean baseset___contains__(PyObject pyObject) {
        try {
            return this._set.contains(pyObject);
        }
        catch (PyException pyException) {
            PyFrozenSet pyFrozenSet = this.asFrozen(pyException, pyObject);
            return this._set.contains(pyFrozenSet);
        }
    }

    @Override
    public int __cmp__(PyObject pyObject) {
        return this.baseset___cmp__(pyObject);
    }

    final int baseset___cmp__(PyObject pyObject) {
        throw Py.TypeError("cannot compare sets using cmp()");
    }

    @Override
    public PyObject __eq__(PyObject pyObject) {
        return this.baseset___eq__(pyObject);
    }

    final PyObject baseset___eq__(PyObject pyObject) {
        if (pyObject instanceof BaseSet) {
            return Py.newBoolean(((Object)this._set).equals(((BaseSet)pyObject)._set));
        }
        return Py.False;
    }

    @Override
    public PyObject __ne__(PyObject pyObject) {
        return this.baseset___ne__(pyObject);
    }

    final PyObject baseset___ne__(PyObject pyObject) {
        if (pyObject instanceof BaseSet) {
            return Py.newBoolean(!((Object)this._set).equals(((BaseSet)pyObject)._set));
        }
        return Py.True;
    }

    @Override
    public PyObject __le__(PyObject pyObject) {
        return this.baseset___le__(pyObject);
    }

    final PyObject baseset___le__(PyObject pyObject) {
        return this.baseset_issubset(this.asBaseSet(pyObject));
    }

    @Override
    public PyObject __ge__(PyObject pyObject) {
        return this.baseset___ge__(pyObject);
    }

    final PyObject baseset___ge__(PyObject pyObject) {
        return this.baseset_issuperset(this.asBaseSet(pyObject));
    }

    @Override
    public PyObject __lt__(PyObject pyObject) {
        return this.baseset___lt__(pyObject);
    }

    final PyObject baseset___lt__(PyObject pyObject) {
        BaseSet baseSet = this.asBaseSet(pyObject);
        return Py.newBoolean(this.size() < baseSet.size() && this.baseset_issubset(pyObject).__nonzero__());
    }

    @Override
    public PyObject __gt__(PyObject pyObject) {
        return this.baseset___gt__(pyObject);
    }

    final PyObject baseset___gt__(PyObject pyObject) {
        BaseSet baseSet = this.asBaseSet(pyObject);
        return Py.newBoolean(this.size() > baseSet.size() && this.baseset_issuperset(pyObject).__nonzero__());
    }

    @Override
    public PyObject __reduce__() {
        return this.baseset___reduce__();
    }

    final PyObject baseset___reduce__() {
        PyTuple pyTuple = new PyTuple(new PyList(this));
        PyObject pyObject = this.__findattr__("__dict__");
        if (pyObject == null) {
            pyObject = Py.None;
        }
        return new PyTuple(this.getType(), pyTuple, pyObject);
    }

    final PyObject baseset_union(PyObject pyObject) {
        BaseSet baseSet = BaseSet.makeNewSet(this.getType(), this);
        baseSet._update(pyObject);
        return baseSet;
    }

    final PyObject baseset_intersection(PyObject pyObject) {
        PyObject pyObject2;
        PyObject pyObject3;
        if (!(pyObject instanceof BaseSet)) {
            pyObject = new PySet(pyObject);
        }
        if (this.size() <= __builtin__.len(pyObject)) {
            pyObject3 = this;
            pyObject2 = pyObject;
        } else {
            pyObject3 = pyObject;
            pyObject2 = this;
        }
        PyObject pyObject4 = __builtin__.filter(pyObject2.__getattr__("__contains__"), pyObject3);
        return BaseSet.makeNewSet(this.getType(), pyObject4);
    }

    final PyObject baseset_copy() {
        BaseSet baseSet = BaseSet.makeNewSet(this.getType(), this);
        return baseSet;
    }

    final PyObject baseset_issubset(PyObject pyObject) {
        BaseSet baseSet;
        BaseSet baseSet2 = baseSet = pyObject instanceof BaseSet ? (BaseSet)pyObject : new PySet(pyObject);
        if (this.size() > baseSet.size()) {
            return Py.False;
        }
        for (PyObject pyObject2 : this._set) {
            if (baseSet._set.contains(pyObject2)) continue;
            return Py.False;
        }
        return Py.True;
    }

    final PyObject baseset_issuperset(PyObject pyObject) {
        BaseSet baseSet = pyObject instanceof BaseSet ? (BaseSet)pyObject : new PySet(pyObject);
        return baseSet.baseset_issubset(this);
    }

    @Override
    public String toString() {
        return this.baseset_toString();
    }

    final String baseset_toString() {
        String string = this.getType().fastGetName();
        ThreadState threadState = Py.getThreadState();
        if (!threadState.enterRepr(this)) {
            return string + "(...)";
        }
        StringBuilder stringBuilder = new StringBuilder(string).append("([");
        Iterator<PyObject> iterator = this._set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().__repr__().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("])");
        threadState.exitRepr(this);
        return stringBuilder.toString();
    }

    protected final BaseSet asBaseSet(PyObject pyObject) {
        if (pyObject instanceof BaseSet) {
            return (BaseSet)pyObject;
        }
        throw Py.TypeError("can only compare to a set");
    }

    protected final PyFrozenSet asFrozen(PyException pyException, PyObject pyObject) {
        if (!(pyObject instanceof BaseSet) || !pyException.match(Py.TypeError)) {
            throw pyException;
        }
        PyFrozenSet pyFrozenSet = new PyFrozenSet();
        pyFrozenSet._set = ((BaseSet)pyObject)._set;
        return pyFrozenSet;
    }

    protected static BaseSet makeNewSet(PyType pyType) {
        return BaseSet.makeNewSet(pyType, null);
    }

    protected static BaseSet makeNewSet(PyType pyType, PyObject pyObject) {
        BaseSet baseSet;
        if (pyType == PySet.TYPE) {
            baseSet = new PySet(pyObject);
        } else if (pyType == PyFrozenSet.TYPE) {
            baseSet = new PyFrozenSet(pyObject);
        } else if (Py.isSubClass(pyType, PySet.TYPE)) {
            baseSet = new PySetDerived(pyType);
            baseSet._update(pyObject);
        } else {
            baseSet = new PyFrozenSetDerived(pyType, pyObject);
        }
        return baseSet;
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public boolean add(Object object) {
        return this._set.add(Py.java2py(object));
    }

    @Override
    public boolean contains(Object object) {
        return this._set.contains(Py.java2py(object));
    }

    @Override
    public boolean remove(Object object) {
        return this._set.remove(Py.java2py(object));
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this._set.contains(Py.java2py(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl |= this._set.remove(Py.java2py(e));
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator<PyObject> real;
            {
                this.real = BaseSet.this._set.iterator();
            }

            public boolean hasNext() {
                return this.real.hasNext();
            }

            public Object next() {
                return Py.tojava(this.real.next(), Object.class);
            }

            public void remove() {
                this.real.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }
}

